# -*- coding: utf-8 -*-

#cons_hJ.py
#@author: Olivier Lantsoght
#
#Created on 23/05/2019
#Last update on 23/05/2019
#
#Copyright 2019 Universite Catholique de Louvain


import numpy as np

def user_cons_hJ(h,Jac,mbs,tsim):
    """ Function that compute the Jacobian and the h vector for the user constraints
    
    :param h: the constraint vector to return
    :param Jac: the jacobian matrix to return
    :param mbs: the Data structure
    """
    #print("user_cons_hJ (Template) : This function should not be called")
    
    # Example: Compute the expression of h and Jac then assign the values.
    # h[1] = mbs.q[1]-mbs.q[2]*mbs.q[2]
    # Jac[1,1] =  1.
    # Jac[1,2] = -2*mbs.q[2].
    # IMPORTANT: NEVER REASSIGN H => h=np.array([0,mbs.q[1]-mbs.q[2]*mbs.q[2],0])
    #            NEVER REASSIGN Jac=>Jac=np.array([[0,0,0,0],[0,1,-2*mbs.q[2],0])
    
    ind = [[12, 13],
           [17, 18],
           [22, 23]]
    
    for i, index in enumerate(ind):
        h[i+1] = mbs.q[index[0]]-mbs.q[index[1]]
        Jac[i+1, index[0]] = 1
        Jac[i+1, index[1]] = -1
    
    return
